(function() {
  //farmerswife - 12/02/2014 - Rafa Dorado
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'models/project/ProjectModel', "views/cfield/CustomFieldView", 'views/contact/ContactListView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, ProjectModel, CustomFieldView, ContactListView) {
    var FormProjectView;
    return FormProjectView = class FormProjectView extends Backbone.View {
      initialize(usr, projectCol, project1) {
        this.usr = usr;
        this.projectCol = projectCol;
        this.project = project1;
        return this.comingFromView = null;
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap .btn-submenu-formproject': 'subMenuAddProjectClicked',
          'pageshow': 'pageShown',
          'tap .edit-contact-project': 'btnSelectContactClicked',
          'tap #id-btn-save-project': 'btnSaveProjectClicked'
        };
      }

      render() {
        var params, template;
        template = Handlebars.templates['FormProjectView'];
        params = null;
        if (this.project) {
          params = {
            project: this.project.toJSON()
          };
        }
        this.$el.html(template(params));
        this.addSidePanel();
        return this.$el;
      }

      pageShown(event) {
        if (!this.comingFromView) {
          return this.__update_cfields_tap();
        }
      }

      addSidePanel() {
        var MenuView;
        if (window.media_query_min_width(768)) {
          if (!MenuView) {
            MenuView = require("views/menu/MenuView");
          }
          this.panel = new MenuView(this.usr, this.obj);
          this.panel.render();
          return this.$el.append(this.panel.el);
        }
      }

      subMenuAddProjectClicked(event) {
        var btn, id;
        event.stopPropagation();
        event.preventDefault();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        $('.subFormProjectView').hide();
        return $(id).show();
      }

      __update_cfields_tap() {
        var cfields, ul;
        ul = this.$el.find('#id-ul-formproject-cfields');
        if (ul.find('li').length === 0) {
          if (!this.project) {
            cfields = JSON.parse('[' + window.localStorage.getItem('ProjectCFields') + ']');
          } else {
            cfields = this.project.get('CustomField');
          }
          if (!_.isArray(cfields)) {
            cfields = [cfields];
          }
          if (!CustomFieldView) {
            CustomFieldView = require("views/cfield/CustomFieldView");
          }
          if (cfields) {
            ul.empty();
            _.each(cfields, (cf) => {
              var cfLi;
              cfLi = new CustomFieldView(this.usr, cf, 'form', 'AddProject').render().el;
              return ul.append(cfLi);
            });
            /* UPDATING DOM STYLE */
            $('#id-divAddProjectCFields').trigger('create');
            return $('#id-ul-formproject-cfields').listview();
          }
        }
      }

      btnSaveProjectClicked(event) {
        var project, reqProject;
        event.stopPropagation();
        event.preventDefault();
        reqProject = {};
        reqProject.name = this.$el.find('#id-input-project-name').val();
        if (!this.project) {
          reqProject.id = 'new';
        } else {
          reqProject.id = this.project.get('id');
        }
        reqProject.note = this.$el.find('#id-textarea-project-note').val();
        reqProject.contactCompanyName = this.$el.find('#id-p-project-company').text();
        reqProject.contactID = this.$el.find('#id-p-project-contact').attr('data-contactID');
        reqProject.contactName = this.$el.find('#id-p-project-contact').text();
        reqProject.CustomField = new Array();
        _.each($('#id-ul-formproject-cfields > li'), function(cf) {
          var cfObj, input, ref, ref1, type, value;
          type = $(cf).attr('data-type');
          switch (type) {
            case 'checkbox':
              value = $(cf).find('select.selector-checkbox-cfield').val();
              break;
            case 'entry':
              if (((ref = $(cf).find('.selector-company-cfield')) != null ? ref.length : void 0) > 0) {
                value = $(cf).find('span.selector-company-cfield').text();
              } else if (((ref1 = $(cf).find('.btn-contact-cfield')) != null ? ref1.length : void 0) > 0) {
                value = $(cf).find('.btn-contact-cfield').text();
              } else {
                value = $(cf).find('.entry-cfield').val();
              }
              break;
            case 'text':
              value = $(cf).find('.text-cfield').val();
              break;
            case 'selector':
              input = $(cf).find('.input-selector-cfield').val();
              if (input) {
                value = input;
              } else {
                value = $(cf).find('.radio-selector-cfield').val();
              }
              break;
            case 'date':
              value = $(cf).find('.input-date-cfield').val();
          }
          cfObj = {
            label: window.html_entities($(cf).attr('data-label')),
            value: window.html_entities(value),
            type: type
          };
          return reqProject.CustomField.push(cfObj);
        });
        project = new ProjectModel();
        project.on('project_saved', this.__refresh_and_go_to_projectList, this);
        return project.save_project(this.usr.get('sessionID'), reqProject);
      }

      __refresh_and_go_to_projectList() {
        var ref;
        if ((ref = this.projectCol) != null) {
          ref.get_projects(this.usr);
        }
        return $.mobile.jqmNavigator.popToFirst({
          transition: 'none'
        });
      }

      btnSelectContactClicked(event) {
        var view;
        event.stopPropagation();
        event.preventDefault();
        if (!ContactListView) {
          ContactListView = require('views/contact/ContactListView');
        }
        view = new ContactListView(this.usr, 'AddProject');
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      addedProjectGlobalContact(view, contact) {
        var companyP, contactP, obj;
        $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
        obj = contact.get('Contact');
        contactP = view.$el.find('#id-p-project-contact');
        contactP.text(obj.firstName + ' ' + obj.lastName);
        contactP.attr('data-contactID', obj.contactID);
        companyP = view.$el.find('#id-p-project-company');
        companyP.text(obj.companyName);
        return companyP.attr('data-companyID', obj.companyID);
      }

      addedProjectCfieldContact(view, contact) {
        var btn, obj;
        //liCfield = view.$el.find('.btn-contact-cfield[data-selected="true"]').closest('li').index()
        view.comingFromView = 'ContactSelector';
        $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
        btn = view.$el.find('.btn-contact-cfield[data-selected="true"]');
        if (btn.length === 0) {
          btn = view.$el.find('.btn-contact-cfield');
        }
        obj = contact.get('Contact');
        //SINCE PAGE SHOWN EVENT, LIST WAS REPRINTED
        //btn = view.$el.find('#id-ul-formproject-cfields li').eq(liCfield).find('.btn-contact-cfield')
        btn.find('.ui-btn-text').text(obj.firstName + ' ' + obj.lastName);
        btn.attr('data-contactID', obj.contactID);
        btn.attr('data-selected', false);
        return btn.button();
      }

      btnBackClicked(event) {
        event.stopPropagation();
        event.preventDefault();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
